//------------------------------------------------------------------------------
// Preset tile patterns for casual users. The tilesets may be either square or
// hexagonal, indicated by the tile strings haveing either four or six
// characters, respectively. Connectors are specified in clockwise order. The
// connector characters mean the following:
//
//     -     ... a hyphen indicates invisible nonpolar connector in this position
//     [0-9] ... a number indicates a connector that connects only to the same
//               number on an adjacent tile without polarity
//     [A-Da-d] ... letters indicate connectors with polarity, e.g., A matches a,
//                  B matches b, C matches c and so on.
//           ... space indicates neighbor must be empty
//
// Tiles will be rotated by the system during the matching process. (Idea: add
// optional unrotateable tiles?) Need a Kleene closure connector - '*'. Also
// need EeFf for hex tiles.
//------------------------------------------------------------------------------

var presets = [
    [ "Mod Airport Terminal",        "'_a_A_a', '____A_'"],                                                                                                           
	[ "Brain Coral",                 "'bbb-b-', 'b-B---', 'B-b---', 'B-----'"],                                                                                       
    [ "CA-ish Shell Pattern",        "'CcCc__'"],                                                                                                                     
    [ "Night of Basic Shapes",       "'__33Aa', '_33_Aa'"],                                                                                                           
    [ "Tire Track",                  "'ab_A__', 'B__C__', 'B__c__', 'B__D__', 'B__d__'"],                                                                             
    [ "Cephalopod Circuits",         "'a__A_4', 'aA____', '4_____', '4_4___'"],                                                                                       
    [ "Cephalopod IC Chips",         "'a__A_4', 'aA____', '4_____'"],                                                                                                 
    [ "Voronoi Traffic Jam",         "'3-3-2-', '3--2--', '1-----'"],                                                                                                 
    [ "Sierpinski Redux",            "'___bB_', 'bAaB__', 'aAaA__'"],                                                                                                 
    [ "Dots and Triangles",          "'B_Aa__', 'b__Aa_'"],                                                                                                           
    [ "Flagellate Network",          "'44____', '11__4_'"],                                                                                                           
    [ "CAT-5 Canoes",                "'_a__4_', '_4_4__', '__A441'"],                                                                                                 
    [ "Uniform Circle Packing",      "'1_1_1_', '2__12_'"],                                                                                                           
    [ "Unstable Nesting",            "'_AAaa_', 'a__A__'"],                                                                                                           
    [ "Triple Allotrope",            "'_a_A__', 'Aaa__A'"],                                                                                                           
    [ "Tropical Chair Weave",        "'a__a__', '_aAA_A'"],                                                                                                           
    [ "Bathroom Tiles",              "'__AA_A', 'a_a_a_'"],                                                                                                           
    [ "Phone Cord Hexagons",         "'a__aa_', '____AA'"],                                                                                                           
    [ "Missing Dots Bureau",         "'A_A_a_', 'a_a___'"],                                                                                                           
    [ "Intermittent Regularity",     "'A_A_a_', 'a__a__'"],                                                                                                           
    [ "Bowsplosion",                 "'_a___4', 'a4_44A', '4A____'"],                                                                                                 
    [ "Solar Vineyard",              "'a_2a2_', '_A___A', '_____2'"],                                                                                                 
    [ "Reinforced Squiggles",        "'141___', '4__4__', '1_1___'"],                                                                                                 
    [ "Brassiere Spool",             "'_Aaa__', 'A1A___', 'a_1AAa'"],                                                                                                 
    [ "Hexagram Crunch",             "'__bB1_', '_b__B_'"],                                                                                                           
    [ "Chiral Suntiles",             "'BbB_1_', '_____b'"],                                                                                                           
    [ "Triangulata",                 "'b__b_b', '__BbB_'"],                                                                                                           
    [ "Allotropic Instability",      "'aA1___', '___AA_', 'a__2__'"],                                                                                                 
    [ "Double Allotrope Surprise",   "'212111', '_1_2__'"],                                                                                                           
    [ "Quiet Disagreement",          "'22222a', '22_A22'"],                                                                                                           
    [ "Tanguy Kong",                 "'2_222_', '2___B2', '__b__2'"],                                                                                                 
    [ "Triangular Interleave",       "'_a_a_a', '___A_A'"],                                                                                                           
    [ "Caterpillar Gridlock",        "'_Dd_cA', '___d_D', '___a_C'"],                                                                                                 
    [ "Suburban 60's Decor",         "'__CCCc', '_3Ca_A', '__3__c', '_____c'"],                                                                                       
    [ "Pie Charts and Shells",       "'_C_dDc', '__CC_C', '___ccC'"],                                                                                                 
    [ "Self-Limiting Triangles",     "'_Aa_Cc', '_____c', '_____C'"],                                                                                                 
    [ "Fullerene Pavilions",         "'_CcDdC', '__cC_c', '_____C'"],                                                                                                 
    [ "Mostly Unruly Rope",          "'A_1_1_','a1___B','b__1__'"],                                                                                                   
    [ "Sunstar Textile Pattern",     "'_44B4D', '_dbB4b', '_44D_d', '____44'"],                                                                                       
    [ "Twisted Chains",              "'__d3_3', '___D_D'"],                                                                                                           
    [ "Breccia",                     "'__cc_c', '_C_C_c'"],                                                                                                           
    [ "Chinese Wrapping Paper",      "'AaAaaa', '__1_Aa', '_____A'"],                                                                                                 
    [ "Space Age Molecules",         "'d_D_3_', 'dD____', '3_____'"],                                                                                                 
    [ "Floral Stained Glass",        "'a_1_A_', 'a__A__'"],                                                                                                           
    [ "Hard vs. Easy Allotropes",    "'cCCcCC', 'cccC__', 'c_C__C'"],                                                                                                 
    [ "Braids and Strings",          "'A44444', 'a4___4', '4_4___'"],                                                                                                 
    [ "Consistent Lozenge",          "'acaACA', 'acbBCB', 'bcaBCB', 'bcbACA'"],                                                                                       
    [ "1D CA Mimic",                 "'A__ab_', 'B_ab__', 'A__a__', 'B__b__', 'ABd__D'"],                                                                             
    [ "Banana Necklace",             "'bBbBBB', 'bb____', 'b___B_'"],                                                                                                 
    [ "Semiregular Chainmail",       "'a_AA_A', 'a_a___'"],                                                                                                           
    [ "Sandstone Cementation",       "'cC_a_A', 'a_A___'"],                                                                                                           
    [ "Multiple Allotropes",         "'bbB__B', 'b_BBB_', 'bb____'"],                                                                                                 
    [ "Orange Tree",                 "'cCc_C_', 'cC_c_C'"],                                                                                                           
    [ "Banana Brick Road",           "'d4_Dd_', 'd_D___', 'DD____'"],                                                                                                 
    [ "Knotwork vs. Rope",           "'aaAA11', '1_1___', 'a__A__', 'a____A'"],                                                                                       
    [ "Xmas Greetings",              "'cCcC__', 'c__C__'"],                                                                                                           
    [ "Tangled Mesh",                "'C22222', 'cC__22', 'cc__2C', '2_2___'"],                                                                                       
    [ "Antlerfest!",                 "'b-B-BB', 'b-----'"],                                                                                                           
    [ "Beachcombing Whimsy",         "'cCc--C', 'cC----', 'c-C---'"],                                                                                                 
    [ "Alien Scriptorium",           "'b_4___', '3_____', 'B___44', '4__3__'"],                                                                                       
    [ "Caffeinated Floorplans",      "'aa_A__', 'c_A___', 'a_____', 'C3____'"],                                                                                       
    [ "Privacy Envelope Pattern",    "'bBBb__', 'b_BBBB', 'bbbbbB'"],                                                                                                 
    [ "Uzumaki Roof Tiles",          "'B_B___', 'bb4_B_', 'B_4___'"],                                                                                                 
    [ "Grandma's Fused Candy Dish",  "'cCc___', 'c_CC__'"],                                                                                                           
    [ "Synagogue Fretwork",          "'b_C_B_', 'c_bC_b', 'c__B__'"],                                                                                                 
    [ "Thick Hex Grid",              "'aaAA__', 'aA_a_A'"],                                                                                                           
    [ "Challenging Upholstery",      "'bBbB_B', 'bB_b__'"],                                                                                                           
    [ "Mackerel Clouds",             "'bB_3B_', 'b33___'"],                                                                                                           
    [ "Ogham Ticker Tape",           "'3_3_', 'b_B3', '3___'"],                                                                                                       
    [ "Cast Block Screen",           "'_111'"],                                                                                                                       
    [ "Ribbed for Your Boredom",     "'abA_', 'B_C_', 'B_c_', 'B_D_', 'B_d_'"],                                                                                       
    [ "TV Color Mask I",             "'4A4a', '__a4', '_A_B', '__Ab'"],                                                                                               
    [ "TV Color Mask II",            "'acAC', 'adBD', 'bcBD', 'bdAC'"],                                                                                               
    [ "Tallies and Hashes",          "'1111', '___1'"],                                                                                                               
    [ "Precolumbian Pottery",        "'_bbb', '__BB'"],                                                                                                               
    [ "Out-of-Band Communications",  "'1B1B', 'a_A_', '_bA_', 'ab_B'"],                                                                                               
    [ "Fancy Cobbles",               "'cC_C', 'cc_C'"],                                                                                                               
    [ "Crosstown Traffic",           "'c-C-', 'cC--'"],                                                                                                               
    [ "Faulty Core Memory",          "'dd11', 'D-3-', '11--'"], // EO henceforth                                                                                      
    [ "Psychotic Schematics",        "'3333', '3_1_', '33__'"],                                                                                                       
    [ "Power Law Flagstones",        "'_111'"],                                                                                                                       
    [ "Pasta Fantasia",              "'1_1___', '111___', '111_1_', '1__1__', '1111__'"],                                                                             
    [ "Trivial Maze",                "'1---', '11--'"],                                                                                                               
    [ "Slightly Less Trivial Maze",  "'1---', '11--', '1-1-'"],                                                                                                       
    [ "Squiggle City",               "'11--', '4-1-'"],                                                                                                               
    [ "Diagonal Vibrations",         "'11--', 'aA-1'"],                                                                                                               
    [ "Offramp Cornucopia",          "'2_2___', '22_2__', '2222__', '22222_', '2_____', '22____'"],                                                                   
    [ "Mobius Strip Mall",           "'2_222_', '2___B2', '__b__2'"],                                                                                                 
    [ "Non-Trivial Maze",            "'2---', '222-', '22--'"],                                                                                                       
    [ "Rectilinear Maze",            "'222-', '2---'"],                                                                                                               
    [ "Collective Hut Complex",      "'3_____', 'd33_D3', 'd_D33_', '33333_'"],                                                                                       
    [ "Scaffoldglyphics",            "'3___', '333_'"],                                                                                                               
    [ "Flagstone Veneer",            "'3_1_', '331_'"],                                                                                                               
    [ "Honeycomb",                   "'3_1_1_', 'ddDADa'"],                                                                                                           
    [ "Open Weave",                  "'333_3_', '3_3___'"],                                                                                                           
    [ "Formica Diner Hex Hash",      "'4__1__', '4_____', '44_14_'"],                                                                                                 
    [ "Varied Ant Corrals",          "'4-----', '22-2--'"],                                                                                                           
    [ "Neuroglia",                   "'4-----', 'dDd-4-', 'D4----'"],                                                                                                 
    [ "Diverse Bricks",              "'4-4-', '444-'"],                                                                                                               
    [ "Foliage of the Seventies",    "'44____', '4_4___', '44_4__'"],                                                                                                 
    [ "Saltine Cracker Matrix",      "'44----', '44--4-'"],                                                                                                           
    [ "Intermittent Grid System",    "'444_', '4___', '4_4_'"],                                                                                                       
    [ "Gummy Tiles",                 "'444_', '44__'"],                                                                                                               
    [ "Gritty Basketweave",          "'4444--', '44-4--'"],                                                                                                           
    [ "OCD Wirewrap",                "'44444_', '444444', '44_44_', '4_4___'"],                                                                                       
    [ "Martian Train Signals",       "'A___', 'aa_A'"],                                                                                                               
    [ "Fluid Script",                "'a___4_', 'A4A___', 'c___4_', 'C_____', '4__4__'"],                                                                             
    [ "Strings and Pegs",            "'a_A___', 'a_A33_'"],                                                                                                           
    [ "Morse Code Dazzler",          "'aA2C', 'cc2_'"],                                                                                                               
    [ "Bone Quilt",                  "'AAA_', 'aa__'"],                                                                                                               
    [ "Intractable Twig Assembly",   "'b_____', 'd__4__', 'd_____', '44____', 'dd4_B_', 'b4_b_B', 'd4BBBD', 'b_D4__', '4_4___', 'bb_D__', 'bBBD__'"],                 
    [ "Isometric Flagstones",        "'B__B__', 'bb__b_', 'bab__A'"],                                                                                                 
    [ "Olympian Bricabrac Shelves",  "'B_2_', 'B___', 'b22_'"],                                                                                                       
    [ "More Bricabrac Shelves",      "'b_b_', 'bB_B', 'B___'"],                                                                                                       
    [ "Cellular Terminal",           "'b_B_B_', 'b_____', 'B_B___', '1_____'"],                                                                                       
    [ "Modular Maze",                "'b---', 'bB-B'"],                                                                                                               
    [ "Reactor Control Panel",       "'b-B-', 'bB--'"],                                                                                                               
    [ "Tanguy's Regimented Phase",   "'B-B-', 'bB--', 'bb-B'"],                                                                                                       
    [ "Squiggly Coastline",          "'B3__', 'bb__'"],                                                                                                               
    [ "Mountain Cantons",            "'BB__', 'bb__', 'bB_B'"],                                                                                                       
    [ "Mongolian Cluster Protein",   "'bb_b__', 'B_B___'"],                                                                                                           
    [ "Chicken Dance Moves",         "'bB-b-a', 'B-----', 'A-----'"],                                                                                                 
    [ "Winter Shrubs",               "'bb4_', 'B4__', '4___'"],                                                                                                       
    [ "Dot Factory Floorplan",       "'bbB-', 'b---', 'b-BB'"],                                                                                                       
    [ "Clique Map",                  "'bbBB', 'bB--'"],                                                                                                               
    [ "Off-Kilter Plat",             "'bC_C', 'C4__', 'B_4_', 'C_4_', 'cb__'"],                                                                                       
    [ "Neoplastic Traffic Lights",   "'c___', 'ccC_', 'cCCC', 'cC__'"],                                                                                               
    [ "Blanket Packing",             "'c_C_', 'c___', 'ccc_', 'cCC_'"],                                                                                               
    [ "Fluorescent Tube Packing",    "'c_C_', 'cCC_', 'cCc_', 'cccC'"],                                                                                               
    [ "Cube Farm of the Apocalypse", "'C---', 'c---', 'bC-C', 'cCB-'"],                                                                                               
    [ "Grey Matter",                 "'c-----', 'c-C-C-', 'C---2-'"],                                                                                                 
    [ "Woodring Pegboard",           "'c--C', 'cC--'"],                                                                                                               
    [ "Bureaucratic Plumbing",       "'C-2-', 'cC--', 'c---', 'cC22', 'c-22'"],                                                                                       
    [ "Toy Building Kit Parts",      "'c-C-', 'cC--'"],                                                                                                               
    [ "Tiki Lounge Wallpaper",       "'C21_', 'c_12', '4_1_'"],                                                                                                       
    [ "Avant-Garde Cube Farm",       "'C3C-', 'c---', 'c--C', '3---', '33--'"],                                                                                       
    [ "Precast Concrete Spill",      "'cc___C', 'CCC___', 'cCCc__', 'c__C__'"],                                                                                       
    [ "Jigsaw Metropolitan",         "'CC----', 'c-2c--', 'c---C-', 'c----C'"],                                                                                       
    [ "Plaited Pasta",               "'CCC_', 'c_1C', 'cc__'"],                                                                                                       
    [ "Suburban Parkland",           "'cCc_', 'C33_', 'c4__', 'c__C'"],                                                                                               
    [ "Retro Newscast Backdrop",     "'ccc-', 'cCCC', 'c-CC', 'ccCC'"],                                                                                               
    [ "Mesoamerican Wall",           "'d___', 'DDD_', 'dd_D', 'dDd_', 'dDD_', 'dD__'"],                                                                               
    [ "Charming Inconsistencies",    "'d__C', 'ccC_', 'b_DC', 'bCBB', 'C___'"],                                                                                       
    [ "Space Age Molecules",         "'d_D_3_', 'dD____', '3_____'"],                                                                                                 
    [ "Ripple Isometry",             "'d_D_4_', 'd__D__', '44____'"],                                                                                                 
    [ "Dissociative Ladder",         "'d_DD', 'D___', 'd_d_'"],                                                                                                       
    [ "Vermicular Crosshatchery",    "'d-DD', 'dddD', 'D---'"],                                                                                                       
    [ "Confetti Script",             "'d1__D_', 'dD____', 'd_____', 'D1____'"],                                                                                       
    [ "Chiclets and Sprinkles",      "'dD_2', 'dbBD'"],                                                                                                               
    [ "Safety Maze",                 "'dD-D', 'ddD-', 'd---', 'DDD-', 'd--D'"],                                                                                       
    [ "Ladder Sigillae",             "'dDd_', 'D___', 'ddD_'"],                                                                                                       
    [ "Pasta and Peas",              "'DDD_', 'dd__'"],                                                                                                               
    [ "Mod Interlock",               "'DDD_', 'ddD_', 'dd__'"],                                                                                                       
    [ "Scroll Storage",              "'ddD-', 'dDD-'"],                                                                                                               
    [ "Ad Hoc Networking",           "'dDdD', 'dD__', 'd_D_'"],                                                                                                       
    [ "Infrequent Mergers",          "'ddDD', 'dDDD', 'dDd_', 'DDD_'"],                                                                                               
    [ "Variable Emphasis",           "'c--C', '11--'"],                        // What causes this?                                                                   
    [ "Shafts and Passages",         "'D---', 'DDD-', 'ddd-'"],                                                                                                       
    [ "Escherian Ladderspace",       "'22--2-', '22-22-', '2-----'"],                                                                                                 
    [ "Tubular Maze",                "'1-1-', '111-', '1---'"],                                                                                                       
    [ "Yarn Seizure",                "'11__', 'a_A_'"],                                                                                                               
    [ "Sparkling Dots",              "'d1DD', 'ddD1'"],                                                                                                               
    [ "Thing Skin",                  "'A_A_2_', 'a__2__'"],                                                                                                           
    [ "Squidgy Maze",                "'4---', '4-4-', '44--', '444-'"],                                                                                               
    [ "Dodecagrams",                 "'aAC___', 'c____2'"],                                                                                                           
    [ "Pig Snouts",                  "'c---D3', 'd----C'"],                                                                                                           
    [ "Egyptian Fretwork",           "'C--2', 'cc--'"],                                                                                                               
    [ "Mismatched Potsherds",        "'a4__', 'a___', 'aA4_', 'aa__', 'AA4_'"],                                                                                       
    [ "Sigillae",                    "'cc_D', 'c___', 'dC__', 'cC__', 'D___', 'c_C_', 'd___', 'c__D'"],                                                               
    [ "Strawpocalypse",              "'44----', '44-4--'"],                                                                                                           
    [ "Infectious Bugs",             "'d_c_C_', 'D_D___', 'd____4'"],                                                                                                 
    [ "Cubiform Gapwork",            "'44444_', '4__4__'"],                          // First awesomery henceforth                                                    
    [ "Rink Rinker Fink",            "'22__', '2___', '2222', '2_2_', '222_'"],                                                                                       
    [ "Manhattan Aerial",            "'D_D_', 'DDDD', 'dddD', 'd___', 'dDD_'"],                                                                                       
    [ "Squidoglyphics",              "'d___', 'ddD2', 'D2__', 'D_2_', 'd__D'"],                                                                                       
    [ "Omnidirectional Tread",       "'a-----', 'A-A---'"],                                                                                                           
    [ "Negative Tenements",          "'d_DD', 'dd11', 'd___', 'D___', 'D11_', 'D1_1', 'ddD1'"],                                                                       
    [ "Globular City",               "'d_D___', 'dDd_D_', 'd__D__'"],                                                                                                 
    [ "Urban Coloring Book",         "'444_4_', '4__4__', '44__4_'"],                                                                                                 
    [ "Electric Irrigation",         "'cbb-', 'CCA-', 'c-C-', 'c-a-', 'c--B'"],                                                                                       
    [ "Mayan Bas Relief",            "'c-C4', 'ccC-', 'C4--', '4-4-'"],                                                                                               
	[ "Skyscraper Castrovalva",      "'4-4---', '44-4--'"],                                                                                                           
	[ "Scallop Sheet Music",         "'D_____', 'b_B___', 'db____', 'd__D_B'"],                                                                                       
	[ "The Devil's Plumbing",        "'1___', '11__', '1_1_', '111_'"],                                                                                               
	[ "Chicklet City",               "'c3C_', 'cC1_'"],                                                                                                               
	[ "Cephalopod Love-In",          "'c-c---', 'c-----', 'cC-CC-', 'c-C---'"],                                                                                       
	[ "Schizoid Paper Tape",         "'222_', 'c2C_'"],                                                                                                               
	[ "Escargot",                    "'ba--a-', 'cc-b--', 'BA----', 'C---B-', 'C-----'"],                                                                             
	[ "Cubicle Maze",                "'1---', '11--', '111-', '1-1-', '1111'"],                                                                                       
	[ "Exquisite Midden",            "'33__3_', '333___'"],                                                                                                           
	[ "Entropic Shelving",           "'dD-D', 'd---'"],                                                                                                               
	[ "Loose Association",           "'dD_a', 'a__A', 'A_2_'"],                                                                                                       
	[ "Hissing into Silence",        "'4---', 'C---', 'c24-', 'c-C-'"],                                                                                               
	[ "Exquisite Radiation",         "'11--1-', 'd--3D-'"],                                                                                                           
	[ "Uncertain Framework",         "'3_____', 'd3_3_D', 'd_D___'"],                                                                                                 
	[ "Higher-Order Hexnet",         "'4___3_', 'b_B_4_'"],                                                                                                           
	[ "Conifer Grabbery",            "'44444-', '4-----'"],                                                                                                           
	[ "Glyptodont Holiday",          "'1111__', '11_1__', '1_____'"],                                                                                                 
	[ "Retro-Whimsy Network",        "'ddD4', 'D_D_', '44__', 'D___'"],                                                                                               
	[ "Scorpions in Amber",          "'bBBB', 'b---', 'b-b-'"],                                                                                                       
	[ "Compound Wicker",             "'b__B_B', 'bbb_BB', 'bbbb_B'"],                                                                                                 
	[ "Rectilinear Islands",         "'a_2_', 'A__2'"],                                                                                                               
	[ "Chair Bingo",                 "'c_C_', 'cccC', 'C___'"],                                                                                                       
    [ "Toadlicker's Dream",          "'a_a___', 'AA_AA_'"],                                                                                                           
    [ "Triskelion Matrix",           "'a2_a__', 'A_A___'"],                                                                                                           
    [ "Quadraphonic Divisatron",     "'aa2_', 'AAA_'"],                                                                                                               
    [ "Mustache Regiment",           "'B-----', 'b---4-', 'B--4--'"],                                                                                                 
    [ "Fuller's Core Memory",        "'B_____', 'c__b__', 'bbB_BC'"],                                                                                                 
    [ "Generic Holiday Thingies",    "'d__DD_', 'd_____'"],                                                                                                           
    [ "Safely Trendy Tiling",        "'CCC_', 'c_c_'"],                                                                                                               
    [ "Meterpocalypse",              "'dDD_', 'dAaa', 'aDAD', 'a_AA'"],                                                                                               
    [ "Shelving Emporium",           "'dBBB', 'D-B-', 'cbB-', 'b---', 'CBB-'"],                                                                                       
    [ "Self-Organizing Halftone",    "'bb11', 'bbBB', 'BB1-', 'b---'"],                                                                                               
    [ "Tricorn Sploder",             "'aA----', 'a--A--'"],                                                                                                           
    [ "His Many Forms",              "'B---', 'bB--', 'bbbB'"],                                                                                                       
    [ "Observant Circuitry",         "'c--C-3', 'c-----', 'c-c---', 'cc-C--', 'c---C3', 'C-C---'"],                                                                   
    [ "Sunmail",                     "'d_3___', 'dDD___'"],                                                                                                           
    [ "Terraced Midtown",            "'33-1', '111-', '33--'"],                                                                                                       
    [ "Turnstile Meta",              "'b__1B_', '1_____'"],                                                                                                           
    [ "Hex Mix",                     "'dD__D_', 'dd__d_'"],                                                                                                           
    [ "Ladder Splatter",             "'43_3', '3___'"],                                                                                                               
    [ "Emergent Phalanx",            "'B-33', 'D---', 'ddb-'"],                                                                                                       
    [ "Brittle Star Heatwave",       "'b_2___', 'B_2___', '2_____', 'b2___B', 'bB22_B'"],                                                                             
    [ "The Devil's Aerial",          "'22_22_', '2__2__'"],                                                                                                           
    [ "Trihex Variations",           "'b_b__4', 'B_B___'"],                                                                                                           
    [ "Dagwood Allotropes",          "'c4_4', 'cc__', 'C_1_'"],                                                                                                       
	[ "Paddle Controls",             "'d--3', 'dD--', 'aDa-', 'A---'"],                                                                                               
	[ "Ink Splatter Chain",          "'c_b_D_', 'D_____', 'd_____', 'DDB__C', 'd__1__'"],                                                                             
	[ "Binary Diversification",      "'aA--', 'dD--'"],                                                                                                               
	[ "Aight",                       "'b___', 'bb__', 'b_BB'"],                                                                                                       
	[ "Dragon Curve",                "'a_a___', 'AA____'"],                                                                                                           
	[ "Coatrack Fantasia",           "'cC_2__', 'C_____', 'cc____', 'a_____', 'A_____'"],                                                                             
	[ "Schnozzglass Crystal",        "'c____b', 'C1____', 'd_b__B', 'c_C_b_', 'D___B_'"],                                                                             
	[ "Bird Guardian Chains",        "'C44___', 'c_____', 'c___2_'"],                                                                                                 
	[ "Squiddity",                   "'ddd_d_', 'd_____', 'd__D__', 'dD___D'"],                                                                                       
	[ "Squighetti Strands",          "'d_B_C_', 'b_C___', 'cc____', 'dCCDd_', 'B_____', 'D_C___', 'c_____'"],                                                         
	[ "Andean Sigil Sweater",        "'3_____', 'CC__C_', 'C____3', 'c__2__'"],                                                                                       
];
